﻿using System.ComponentModel.DataAnnotations;
using System.Linq;
using PpmsDataWebService.Models;
using PpmsDataWebService.ModelsEnumTypes;

namespace PpmsDataWebService.Models
{
    public class ProviderAgreement
    {
        [Key]
        public string AgreementId { get; set; }

        public string AgreementProviderName { get; set; }

        public ProviderType ProviderType { get; set; }
        
        public string CategoryOfCareName { get; set; }

        public string ProviderFacilityName { get; set; }

        public AgreementStatus AgreementStatus { get; set; }

        public string EffectiveDate { get; set; }

        public string ExpirationDate { get; set; }
        //Single
        public virtual IQueryable<Facility> ProviderFacility { get; set; }

        public virtual IQueryable<ProviderSpecialty> CategoryOfCare { get; set; }

        public virtual IQueryable<Provider> AgreementProvider { get; set; }

        public virtual IQueryable<AgreementProvider> AgreementProviders { get; set; }

        public virtual IQueryable<ProviderService> ProviderServices { get; set; }
        
    }
}